"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getOngoingPrescriptions", {
    enumerable: true,
    get: function() {
        return getOngoingPrescriptions;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _ongoingPrescriptionschema = require("@tamanu/shared/schemas/patientPortal/responses/ongoingPrescription.schema");
const _schemaUtils = require("../../utils/schemaUtils");
const _sequelize = require("sequelize");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getOngoingPrescriptions = (0, _expressasynchandler.default)(async (req, res)=>{
    const { patient } = req;
    const { models } = req.store;
    // Filter prescriptions to only include those that are ongoing for the target patient.
    // This requires joining with the PatientOngoingPrescription table for the filter condition,
    // but since no fields from that table are needed in the result, we pass an empty attributes array.
    const prescriptions = await models.Prescription.findAll({
        attributes: (0, _schemaUtils.getAttributesFromSchema)(_ongoingPrescriptionschema.OngoingPrescriptionSchema),
        where: {
            discontinued: {
                [_sequelize.Op.not]: true
            }
        },
        include: [
            {
                model: models.PatientOngoingPrescription,
                as: 'patientOngoingPrescription',
                where: {
                    patientId: patient.id
                },
                attributes: []
            },
            {
                model: models.ReferenceData,
                as: 'medication',
                attributes: (0, _schemaUtils.getAttributesFromSchema)(_ongoingPrescriptionschema.OngoingPrescriptionSchema.shape.medication)
            },
            {
                model: models.User,
                as: 'prescriber',
                attributes: (0, _schemaUtils.getAttributesFromSchema)(_ongoingPrescriptionschema.OngoingPrescriptionSchema.shape.prescriber)
            }
        ]
    });
    res.send({
        data: prescriptions.map((prescription)=>_ongoingPrescriptionschema.OngoingPrescriptionSchema.parse(prescription.forResponse()))
    });
});

//# sourceMappingURL=ongoingPrescriptions.js.map