"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "patientDataRoutes", {
    enumerable: true,
    get: function() {
        return patientDataRoutes;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _allergies = require("./allergies");
const _patient = require("./patient");
const _ongoingConditions = require("./ongoingConditions");
const _ongoingPrescriptions = require("./ongoingPrescriptions");
const _vaccinations = require("./vaccinations");
const _appointments = require("./appointments");
const _surveys = require("./surveys");
const _procedures = require("./procedures");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const patientDataRoutes = _express.default.Router();
patientDataRoutes.get('/', _patient.getPatient);
patientDataRoutes.get('/ongoing-conditions', _ongoingConditions.getOngoingConditions);
patientDataRoutes.get('/allergies', _allergies.getAllergies);
patientDataRoutes.get('/ongoing-prescriptions', _ongoingPrescriptions.getOngoingPrescriptions);
patientDataRoutes.get('/vaccinations/upcoming', _vaccinations.getUpcomingVaccinations);
patientDataRoutes.get('/vaccinations/administered', _vaccinations.getAdministeredVaccines);
patientDataRoutes.get('/appointments/upcoming', _appointments.getUpcomingAppointments);
patientDataRoutes.get('/procedures', _procedures.getProcedures);
patientDataRoutes.get('/surveys/outstanding', _surveys.getOutstandingSurveys);
patientDataRoutes.post('/surveys/:assignmentId', _surveys.createSurveyResponse);

//# sourceMappingURL=patientDataRoutes.js.map