"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE = {
    schema: 'fhir',
    tableName: 'service_requests'
};
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.Sequelize.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        version_id: {
            type: _sequelize.Sequelize.UUID,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        upstream_id: {
            type: _sequelize.Sequelize.STRING,
            allowNull: false
        },
        last_updated: {
            type: _sequelize.Sequelize.DATE,
            defaultValue: _sequelize.Sequelize.NOW,
            allowNull: false
        },
        identifier: {
            type: 'fhir.identifier[]',
            allowNull: false,
            defaultValue: '{}'
        },
        status: {
            type: _sequelize.Sequelize.STRING(16),
            allowNull: false
        },
        intent: {
            type: _sequelize.Sequelize.STRING(16),
            allowNull: false
        },
        category: {
            type: 'fhir.codeable_concept[]',
            allowNull: false,
            defaultValue: '{}'
        },
        priority: {
            type: _sequelize.Sequelize.STRING(10),
            allowNull: true
        },
        order_detail: {
            type: 'fhir.codeable_concept[]',
            allowNull: false,
            defaultValue: '{}'
        },
        subject: {
            type: _sequelize.Sequelize.UUID,
            allowNull: false,
            references: {
                model: {
                    schema: 'fhir',
                    tableName: 'patients'
                },
                key: 'id'
            }
        },
        occurrence_date_time: {
            type: 'date_time_string',
            allowNull: true
        },
        requester: {
            type: _sequelize.Sequelize.UUID,
            allowNull: true,
            references: {
                model: {
                    schema: 'fhir',
                    tableName: 'practitioners'
                },
                key: 'id'
            }
        },
        location_code: {
            type: 'fhir.codeable_concept[]',
            allowNull: false,
            defaultValue: '{}'
        }
    });
    await query.addIndex(TABLE, [
        'id',
        'version_id'
    ]);
    await query.addIndex(TABLE, [
        'upstream_id'
    ]);
}
async function down(query) {
    await query.dropTable(TABLE);
}

//# sourceMappingURL=102_fhirServiceRequestTable.js.map