"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const CURRENT_SYNC_TIME_KEY = 'currentSyncTime';
async function up(query) {
    await query.bulkInsert('local_system_facts', [
        {
            id: _sequelize.default.fn('uuid_generate_v4'),
            created_at: new Date(),
            updated_at: new Date(),
            key: CURRENT_SYNC_TIME_KEY,
            value: '1'
        }
    ]);
}
async function down(query) {
    await query.bulkDelete('local_system_facts', {
        key: CURRENT_SYNC_TIME_KEY
    });
}

//# sourceMappingURL=122_initialiseSyncClock.js.map