"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE = {
    schema: 'fhir',
    tableName: 'non_fhir_medici_report'
};
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.Sequelize.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        version_id: {
            type: _sequelize.Sequelize.UUID,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        upstream_id: {
            type: _sequelize.Sequelize.STRING,
            allowNull: false
        },
        last_updated: {
            type: _sequelize.Sequelize.DATE,
            defaultValue: _sequelize.Sequelize.NOW,
            allowNull: false
        },
        patient_id: {
            type: _sequelize.Sequelize.TEXT,
            allowNull: false
        },
        first_name: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        last_name: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        date_of_birth: {
            type: _sequelize.DataTypes.STRING
        },
        age: {
            type: _sequelize.DataTypes.INTEGER
        },
        sex: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        patient_billing_id: {
            type: _sequelize.DataTypes.STRING
        },
        patient_billing_type: {
            type: _sequelize.DataTypes.TEXT
        },
        encounter_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        encounter_start_date: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        encounter_end_date: {
            type: _sequelize.DataTypes.STRING
        },
        discharge_date: {
            type: _sequelize.DataTypes.STRING
        },
        encounter_type: {
            type: _sequelize.DataTypes.JSONB
        },
        weight: {
            type: _sequelize.DataTypes.DECIMAL
        },
        visit_type: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        episode_end_status: {
            type: _sequelize.DataTypes.JSONB
        },
        encounter_discharge_disposition: {
            type: _sequelize.DataTypes.JSONB
        },
        triage_category: {
            type: _sequelize.DataTypes.TEXT
        },
        wait_time: {
            type: _sequelize.DataTypes.STRING
        },
        departments: {
            type: _sequelize.DataTypes.JSONB
        },
        locations: {
            type: _sequelize.DataTypes.JSONB
        },
        reason_for_encounter: {
            type: _sequelize.DataTypes.TEXT
        },
        diagnoses: {
            type: _sequelize.DataTypes.JSONB
        },
        medications: {
            type: _sequelize.DataTypes.JSONB
        },
        vaccinations: {
            type: _sequelize.DataTypes.JSONB
        },
        procedures: {
            type: _sequelize.DataTypes.JSONB
        },
        lab_requests: {
            type: _sequelize.DataTypes.JSONB
        },
        imaging_requests: {
            type: _sequelize.DataTypes.JSONB
        },
        notes: {
            type: _sequelize.DataTypes.JSONB
        }
    });
    await query.addIndex(TABLE, [
        'id',
        'version_id'
    ]);
    await query.addIndex(TABLE, [
        'upstream_id'
    ]);
}
async function down(query) {
    await query.dropTable(TABLE);
}

//# sourceMappingURL=1707804423068-addFijiMediciReportTable.js.map