export declare const ERROR_TYPE: {
    readonly AUTH: "auth";
    readonly AUTH_CREDENTIAL_INVALID: "auth-credential-invalid";
    readonly AUTH_CREDENTIAL_MISSING: "auth-credential-missing";
    readonly AUTH_PERMISSION_REQUIRED: "auth-permission-required";
    readonly AUTH_QUOTA_EXCEEDED: "auth-quota-exceeded";
    readonly AUTH_TOKEN_INVALID: "auth-token-invalid";
    readonly CLIENT_INCOMPATIBLE: "client-incompatible";
    readonly DATABASE: "database";
    readonly EDIT_CONFLICT: "conflict";
    readonly FORBIDDEN: "forbidden";
    readonly NOT_FOUND: "not-found";
    readonly RATE_LIMITED: "rate-limited";
    readonly REMOTE: "remote";
    readonly REMOTE_INCOMPATIBLE: "remote-incompatible";
    readonly REMOTE_UNREACHABLE: "remote-unreachable";
    readonly STORAGE_INSUFFICIENT: "storage-insufficient";
    readonly UNKNOWN: "unknown";
    readonly UNIMPLEMENTED: "unimplemented";
    readonly VALIDATION: "validation";
    readonly VALIDATION_CONSTRAINT: "validation-constraint";
    readonly VALIDATION_DATABASE: "validation-database";
    readonly VALIDATION_DUPLICATE: "validation-duplicate";
    readonly VALIDATION_OPERATION: "validation-operation";
    readonly VALIDATION_PARAMETER: "validation-parameter";
    readonly VALIDATION_RELATION: "validation-relation";
};
export type ErrorType = (typeof ERROR_TYPE)[keyof typeof ERROR_TYPE];
export declare const IANA_TYPES: ErrorType[];
/** @internal used only within this package */
export declare function isKnownErrorType(type: string): type is ErrorType;
/** @internal used only within this package */
export declare const WELL_KNOWN_PROBLEM_KEYS: string[];
//# sourceMappingURL=constants.d.ts.map