/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('encounter_diets', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        encounter_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'encounters',
                key: 'id'
            }
        },
        diet_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    const [encounters] = await query.sequelize.query(`SELECT e.id, e.diet_id "dietId" FROM encounters e WHERE e.diet_id IS NOT NULL;`, {
        raw: true
    });
    for (const encounter of encounters){
        await query.sequelize.query(`INSERT INTO encounter_diets (encounter_id, diet_id, created_at, updated_at) VALUES (:encounterId, :dietId, now(), now());`, {
            replacements: {
                encounterId: encounter.id,
                dietId: encounter.dietId
            }
        });
    }
    await query.removeColumn('encounters', 'diet_id');
}
async function down(query) {
    await query.addColumn('encounters', 'diet_id', {
        type: _sequelize.DataTypes.TEXT,
        allowNull: true,
        references: {
            model: 'reference_data',
            key: 'id'
        }
    });
    const [encounterDiets] = await query.sequelize.query(`SELECT DISTINCT ON (encounter_id) encounter_id, diet_id FROM encounter_diets;`, {
        raw: true
    });
    for (const encounterDiet of encounterDiets){
        await query.sequelize.query(`UPDATE encounters SET diet_id = :dietId WHERE id = :encounterId;`, {
            replacements: {
                encounterId: encounterDiet.encounter_id,
                dietId: encounterDiet.diet_id
            }
        });
    }
    await query.dropTable('encounter_diets');
}

//# sourceMappingURL=1721791220826-addEncounterDietTable.js.map