"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    // Prescriptions that had been discontinued automatically by the MedicationDiscontinuer
    // prior to 2.34 had no discontinued date.
    await query.sequelize.query(`
    UPDATE prescriptions
    SET discontinued_date = end_date
    WHERE discontinued = true AND discontinued_date IS NULL
  `);
    // Rebuild lookup table so that the correct discontinued date is present
    await query.sequelize.query(`
    SELECT flag_lookup_model_to_rebuild('prescriptions');
  `);
}
async function down() {
// No reverse behaviour here
}

//# sourceMappingURL=1756948183158-CorrectDiscontinuedDateForHistoricallyDiscontinuedPrescriptions.js.map