import { Sequelize } from 'sequelize';
import type { Models } from '../types/model';
/**
 * Bump the updated_at_sync_tick for all records that require a repull
 * So that they are pulled again in the next sync
 * Records generally require repull when they are changed by some side effect
 * of incoming sync, e.g. deduplicating patient display ids in the incomingSyncHook,
 * or field-wise merge of patient additional data records
 * @param sequelize
 * @param persistedModels
 * @param sessionId
 */
export declare const bumpSyncTickForRepull: (sequelize: Sequelize, persistedModels: Models, sessionId: string) => Promise<void>;
//# sourceMappingURL=bumpSyncTickForRepull.d.ts.map