"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PrintableBarcode", {
    enumerable: true,
    get: function() {
        return PrintableBarcode;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _jsbarcode = /*#__PURE__*/ _interop_require_default(require("jsbarcode"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const PrintableBarcode = ({ id, width = 105, barWidth = 1, barHeight = 35, fontSize = 13, margin = 0, barcodeStyle = {} })=>{
    // eslint-disable-next-line no-undef
    const canvas = document.createElement('canvas');
    (0, _jsbarcode.default)(canvas, id, {
        width: barWidth,
        height: barHeight,
        fontSize: fontSize,
        ...barcodeStyle
    });
    const barcode = canvas.toDataURL();
    return /*#__PURE__*/ _react.default.createElement(_renderer.Image, {
        source: barcode,
        style: {
            width,
            margin
        }
    });
};

//# sourceMappingURL=PrintableBarcode.js.map