"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "TaskTemplateExporter", {
    enumerable: true,
    get: function() {
        return TaskTemplateExporter;
    }
});
const _constants = require("@tamanu/constants");
const _ReferenceDataExporter = require("./ReferenceDataExporter");
const _ms = /*#__PURE__*/ _interop_require_default(require("ms"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let TaskTemplateExporter = class TaskTemplateExporter extends _ReferenceDataExporter.ReferenceDataExporter {
    async getData() {
        const tasks = await this.models.ReferenceData.findAll({
            where: {
                type: _constants.REFERENCE_TYPES.TASK_TEMPLATE
            },
            include: {
                model: this.models.TaskTemplate,
                as: 'taskTemplate',
                include: {
                    model: this.models.TaskTemplateDesignation,
                    as: 'designations',
                    include: {
                        model: this.models.ReferenceData,
                        as: 'designation',
                        attributes: [
                            'id'
                        ]
                    }
                }
            }
        });
        return tasks.map((task)=>({
                ...task.dataValues,
                highPriority: task.taskTemplate?.highPriority,
                assignedTo: task.taskTemplate?.designations.map((it)=>it.designation.id).join(', '),
                taskFrequency: task.taskTemplate?.frequencyValue && task.taskTemplate?.frequencyUnit ? (0, _ms.default)((0, _ms.default)(`${task.taskTemplate.frequencyValue} ${task.taskTemplate.frequencyUnit}`), {
                    long: true
                }) : null
            }));
    }
    customHiddenColumns() {
        return [
            'type',
            'taskTemplate'
        ];
    }
};

//# sourceMappingURL=TaskTemplateExporter.js.map