"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    readJSON: function() {
        return readJSON;
    },
    sanitizeFilename: function() {
        return sanitizeFilename;
    },
    verifyQuery: function() {
        return verifyQuery;
    }
});
const _sequelize = require("sequelize");
const _getReportQueryReplacements = require("@tamanu/shared/utils/reports/getReportQueryReplacements");
const _fs = /*#__PURE__*/ _interop_require_default(require("fs"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const sanitizeFilename = (reportName, versionNumber, format)=>{
    const sanitizedName = reportName.trim().replace(/[/?<>\\:*|"]/g, '').replace(/(\s|-)+/g, '-').toLowerCase();
    return `${sanitizedName}-v${versionNumber}.${format}`;
};
const readJSON = async (path)=>{
    return new Promise((resolve, reject)=>{
        _fs.default.readFile(path, 'utf8', (err, data)=>{
            if (err) {
                reject(err);
            } else {
                try {
                    const json = JSON.parse(data);
                    resolve(json);
                } catch (parseError) {
                    reject(parseError);
                }
            }
        });
    });
};
async function verifyQuery(query, { parameters = [] }, { store, reportSchemaStores }, dbSchema) {
    try {
        const replacements = await (0, _getReportQueryReplacements.getReportQueryReplacements)(parameters);
        const instance = reportSchemaStores?.[dbSchema] ? reportSchemaStores[dbSchema]?.sequelize : store.sequelize;
        // use EXPLAIN instead of PREPARE because we don't want to stuff around deallocating the statement
        await instance.query(`EXPLAIN ${query}`, {
            type: _sequelize.QueryTypes.SELECT,
            replacements
        });
    } catch (err) {
        throw new Error(`Invalid query: ${err.message}`);
    }
}

//# sourceMappingURL=utils.js.map