"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "healthRoutes", {
    enumerable: true,
    get: function() {
        return healthRoutes;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _lodash = require("lodash");
const _logging = require("@tamanu/shared/services/logging");
const _migrations = require("@tamanu/database/services/migrations");
const _serverInfo = require("./serverInfo");
const _getFreeDiskSpace = require("./utils/getFreeDiskSpace");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const healthRoutes = _express.default.Router();
// quick utility to track uptime
const startupTime = Date.now();
function uptime() {
    const uptimeMs = Date.now() - startupTime;
    const uptimeS = Math.floor(uptimeMs / 1000);
    const uptimeM = uptimeS / 60;
    return `${Math.floor(uptimeM)}m${(uptimeS % 60).toFixed(0)}s`;
}
// quick utility to recurse through an object
// (to use with sanitising the config object)
function recurse(object, cb, prefix = '') {
    return Object.entries(object).reduce((state, [k, v])=>{
        if ((0, _lodash.isObject)(v)) {
            return {
                ...state,
                [k]: recurse(v, cb, `${prefix}${k}.`)
            };
        }
        return {
            ...state,
            [k]: cb(`${prefix}${k}`, v)
        };
    }, {});
}
function sanitise(object) {
    const re = /secret|key|password/i;
    return recurse(object, (k, v)=>{
        if (!v) return v;
        if (!k.match(re)) return v;
        return '********';
    });
}
async function getMigrations(sequelize) {
    try {
        const migrationManager = (0, _migrations.createMigrationInterface)(_logging.log, sequelize);
        const migrations = (await migrationManager.executed()).map((x)=>x.file);
        return {
            migrations
        };
    } catch (e) {
        return {
            migrationError: e.toString()
        };
    }
}
function lofiCheckPermission(user) {
    if (user?.role !== 'admin') {
        throw new Error('forbidden');
    }
}
healthRoutes.get('/', (0, _expressasynchandler.default)(async (req, res)=>{
    try {
        // TODO: replace with a proper permission check
        // once that's been implemented for central-server, for eg:
        // req.checkPermission('read', 'SystemStatus');
        lofiCheckPermission(req.user);
    } catch (e) {
        res.send({
            version: _serverInfo.version
        });
        return;
    }
    res.send({
        version: _serverInfo.version,
        uptime: uptime(),
        serverTime: new Date(),
        timeOptions: Intl.DateTimeFormat().resolvedOptions(),
        database: {
            options: req.store.sequelize.options,
            ...await getMigrations(req.store.sequelize)
        },
        config: sanitise(_config.default)
    });
}));
healthRoutes.get('/canUploadAttachment', (0, _expressasynchandler.default)(async (req, res)=>{
    const { settings } = req;
    const canUpload = await (0, _getFreeDiskSpace.canUploadAttachment)(settings);
    res.send({
        canUploadAttachment: canUpload
    });
}));

//# sourceMappingURL=health.js.map