"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "generateOrderClause", {
    enumerable: true,
    get: function() {
        return generateOrderClause;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _common = require("./common");
const _jsonb = require("./jsonb");
function generateOrderClause(query, parameters, FhirResource) {
    let ordering = [];
    for (const { order, by } of query.get('_sort').flatMap((v)=>v.value)){
        const def = parameters.get(by);
        if (def.path.length === 0) continue;
        const alternates = def.path.map(([field, ...path])=>{
            const resolvedPath = [
                (0, _common.findField)(FhirResource, field).field,
                ...path
            ];
            return singleOrder(resolvedPath, order, def, FhirResource);
        });
        ordering = ordering.concat(alternates);
    }
    return ordering;
}
// eslint-disable-next-line no-unused-vars
function singleOrder(path, order, def, _Model) {
    const entirePath = path;
    if (def.type === _constants.FHIR_SEARCH_PARAMETERS.TOKEN && (def.tokenType === _constants.FHIR_SEARCH_TOKEN_TYPES.CODING || def.tokenType === _constants.FHIR_SEARCH_TOKEN_TYPES.VALUE)) {
        const valuePath = def.tokenType === _constants.FHIR_SEARCH_TOKEN_TYPES.VALUE ? 'value' : 'code';
        entirePath.push(valuePath);
    }
    // optimisation in the simple case
    if (entirePath.length === 1) {
        return [
            _sequelize.Sequelize.col(entirePath[0]),
            `${order} NULLS LAST`
        ];
    }
    return [
        (0, _jsonb.getJsonbQueryFn)(entirePath),
        `${order} NULLS LAST`
    ];
}

//# sourceMappingURL=order.js.map