"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getHL7Link", {
    enumerable: true,
    get: function() {
        return getHL7Link;
    }
});
const _lodash = require("lodash");
function getHL7Link(baseUrl, params = {}) {
    const query = Object.entries(params).filter(([, v])=>v !== null && v !== undefined).map(([k, v])=>{
        const encodedKey = encodeURIComponent(k);
        const toPair = (val)=>`${encodedKey}=${encodeURIComponent(val)}`;
        if ((0, _lodash.isArray)(v)) {
            return v.map(toPair);
        }
        return [
            toPair(v)
        ];
    }).flat().join('&');
    const url = new URL(baseUrl);
    url.search = new URLSearchParams(query);
    return url.toString();
}

//# sourceMappingURL=getHL7Link.js.map