"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    OPERATIONS: function() {
        return OPERATIONS;
    },
    remoteRequest: function() {
        return remoteRequest;
    },
    remoteResponse: function() {
        return remoteResponse;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _datefns = require("date-fns");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const OPERATIONS = {
    INSERT: 'INSERT',
    UPDATE: 'UPDATE',
    DELETE: 'DELETE'
};
// allow either native date objects or ISO 8601 strings
const transformDate = (_, d)=>{
    if (d instanceof Date) {
        return d;
    }
    if (d === null || d === undefined) {
        return d;
    }
    return (0, _datefns.parseISO)(d);
};
const remoteRequest = {
    patientCreated: _yup.object({
        fetch_id: _yup.string().required(),
        operation: _yup.string().required().oneOf(Object.keys(OPERATIONS)),
        created_datetime: _yup.date().required().transform(transformDate)
    }).required()
};
const remoteResponse = {
    token: _yup.object({
        access_token: _yup.string().required(),
        expires_in: _yup.number().required().integer(),
        token_type: _yup.string().required().oneOf([
            'bearer'
        ])
    }).required(),
    fetchPatient: _yup.object({
        response: _yup.string().required().oneOf([
            'success'
        ]),
        data: _yup.object({
            // Patient fields
            individual_refno: _yup.string().required(),
            fname: _yup.string().nullable(),
            lname: _yup.string().nullable(),
            dob: _yup.date().transform(transformDate).nullable(),
            sex: _yup.string().required().oneOf([
                'male',
                'female',
                'other'
            ]).transform((g)=>g.toLowerCase()),
            sub_division: _yup.string().nullable(),
            email: _yup.string().nullable(),
            // PatientAdditionalData fields
            phone: _yup.string().nullable(),
            // PatientVRSData fields
            id_type: _yup.string().required(),
            identifier: _yup.string().required()
        }).required()
    }),
    acknowledge: _yup.object({
        response: _yup.boolean().required().oneOf([
            true
        ])
    }),
    fetchAllPendingActions: _yup.object({
        response: _yup.string().required().oneOf([
            'success'
        ]),
        data: _yup.array(_yup.object({
            Id: _yup.string().required(),
            Operation: _yup.string().required().oneOf(Object.keys(OPERATIONS)),
            CreatedDateTime: _yup.date().required().transform(transformDate)
        }).required()).required()
    })
};

//# sourceMappingURL=schema.js.map