"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createSurveyResponse: function() {
        return createSurveyResponse;
    },
    getOutstandingSurveys: function() {
        return getOutstandingSurveys;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _logging = require("@tamanu/shared/services/logging");
const _constants = require("@tamanu/constants");
const _portalSurveyAssignmentschema = require("@tamanu/shared/schemas/patientPortal/responses/portalSurveyAssignment.schema");
const _schemaUtils = require("../../utils/schemaUtils");
const _createSurveyResponseschema = require("@tamanu/shared/schemas/patientPortal/requests/createSurveyResponse.schema");
const _errors = require("@tamanu/errors");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getOutstandingSurveys = (0, _expressasynchandler.default)(async (req, res)=>{
    const { patient } = req;
    const { models } = req.store;
    const outstandingSurveys = await models.PortalSurveyAssignment.findAll({
        where: {
            patientId: patient.id,
            status: _constants.PORTAL_SURVEY_ASSIGNMENTS_STATUSES.OUTSTANDING
        },
        attributes: (0, _schemaUtils.getAttributesFromSchema)(_portalSurveyAssignmentschema.PortalSurveyAssignmentSchema),
        include: [
            {
                model: models.Survey,
                attributes: (0, _schemaUtils.getAttributesFromSchema)(_portalSurveyAssignmentschema.PortalSurveyAssignmentSchema.shape.survey),
                as: 'survey'
            },
            {
                model: models.User,
                attributes: (0, _schemaUtils.getAttributesFromSchema)(_portalSurveyAssignmentschema.PortalSurveyAssignmentSchema.shape.assignedBy),
                as: 'assignedBy'
            }
        ]
    });
    return res.send({
        data: outstandingSurveys.map((survey)=>_portalSurveyAssignmentschema.PortalSurveyAssignmentSchema.parse(survey.forResponse()))
    });
});
const createSurveyResponse = (0, _expressasynchandler.default)(async (req, res)=>{
    const { patient, settings, params } = req;
    const { models } = req.store;
    const { assignmentId } = params;
    const body = _createSurveyResponseschema.CreateSurveyResponseRequestSchema.parse(req.body);
    const assignedSurvey = await models.PortalSurveyAssignment.findOne({
        where: {
            id: assignmentId,
            patientId: patient.id,
            status: _constants.PORTAL_SURVEY_ASSIGNMENTS_STATUSES.OUTSTANDING,
            surveyId: body.surveyId
        }
    });
    if (!assignedSurvey) {
        _logging.log.error('Patient attempted to submit response for invalid assigned survey', {
            assignmentId,
            patientId: patient.id,
            surveyId: body.surveyId
        });
        throw new _errors.NotFoundError('Survey was not assigned to the patient');
    }
    const responseRecord = await req.store.sequelize.transaction(async ()=>{
        const getDefaultId = async (type)=>models.SurveyResponseAnswer.getDefaultId(type, settings);
        const { locationId, departmentId, ...payload } = body;
        const updatedBody = {
            patientId: patient.id,
            locationId: locationId || await getDefaultId('location'),
            departmentId: departmentId || await getDefaultId('department'),
            userId: _constants.SYSTEM_USER_UUID,
            // facilityId, // TODO: add to form assignment ?
            ...payload
        };
        const surveyResponse = await models.SurveyResponse.createWithAnswers(updatedBody);
        await assignedSurvey.update({
            surveyResponseId: surveyResponse.id,
            status: _constants.PORTAL_SURVEY_ASSIGNMENTS_STATUSES.COMPLETED
        });
        return surveyResponse;
    });
    return res.send(responseRecord);
});

//# sourceMappingURL=surveys.js.map