"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "LabRequestNotificationGenerator", {
    enumerable: true,
    get: function() {
        return LabRequestNotificationGenerator;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _logging = require("@tamanu/shared/services/logging");
const _tasks = require("@tamanu/shared/tasks");
const _utils = require("@tamanu/shared/utils");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let LabRequestNotificationGenerator = class LabRequestNotificationGenerator extends _tasks.ScheduledTask {
    getName() {
        return 'LabRequestNotificationGenerator';
    }
    async countQueue() {
        const { CertificateNotification, LabRequest } = this.context.store.models;
        return LabRequest.count({
            where: {
                status: _constants.LAB_REQUEST_STATUSES.PUBLISHED,
                '$certificate_notification.id$': null
            },
            include: [
                {
                    model: CertificateNotification,
                    as: 'certificate_notification',
                    required: false,
                    where: {
                        type: {
                            [_sequelize.Op.ne]: _constants.COVID_19_CLEARANCE_CERTIFICATE
                        }
                    }
                }
            ]
        });
    }
    async run() {
        const { models } = this.context.store;
        const { CertificateNotification, Encounter, LabRequest } = models;
        const categories = _config.default.notifications.certificates.labTestCategoryIds;
        const questionId = await this.context.settings.get('questionCodeIds.email');
        // Find all published requests that don't have associated certificate notifications
        const newlyPublished = await LabRequest.findAll({
            where: {
                status: 'published',
                '$certificate_notification.id$': null
            },
            include: [
                {
                    model: CertificateNotification,
                    as: 'certificate_notification',
                    required: false
                },
                {
                    model: Encounter,
                    as: 'encounter',
                    required: true
                }
            ]
        });
        // Create a certificate notification for each
        for (const labRequest of newlyPublished){
            const emailAddress = await (0, _utils.getPatientSurveyResponseAnswer)(models, labRequest.encounter.patientId, questionId);
            await CertificateNotification.create({
                type: _constants.ICAO_DOCUMENT_TYPES.PROOF_OF_TESTING.JSON,
                requiresSigning: false,
                patientId: labRequest.encounter.patientId,
                // If forward address is null, the communication service will
                // attempt to use the patient.email field
                forwardAddress: emailAddress,
                // Queue up emails for white listed categories
                status: categories.includes(labRequest.labTestCategoryId) ? _constants.CERTIFICATE_NOTIFICATION_STATUSES.QUEUED : _constants.CERTIFICATE_NOTIFICATION_STATUSES.IGNORE,
                labRequestId: labRequest.id
            });
        }
    }
    constructor(context){
        const conf = _config.default.schedules.certificateNotificationProcessor;
        super(null, _logging.log);
        this.config = conf;
        this.context = context;
    }
};

//# sourceMappingURL=LabRequestNotificationGenerator.js.map