"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PortalCommunicationProcessor", {
    enumerable: true,
    get: function() {
        return PortalCommunicationProcessor;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _replaceInTemplate = require("@tamanu/utils/replaceInTemplate");
const _errors = require("@tamanu/errors");
const _constants = require("@tamanu/constants");
const _BaseCommunicationProcessor = require("./BaseCommunicationProcessor");
const _PortalOneTimeTokenService = require("../patientPortal/auth/PortalOneTimeTokenService");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let PortalCommunicationProcessor = class PortalCommunicationProcessor extends _BaseCommunicationProcessor.BaseCommunicationProcessor {
    async transformContent({ content, patientId, type }) {
        const { models } = this.context.store;
        const portalOneTimeTokenService = new _PortalOneTimeTokenService.PortalOneTimeTokenService(models);
        const portalUser = await models.PortalUser.findOne({
            where: {
                patientId
            }
        });
        if (!portalUser) {
            throw new _errors.NotFoundError(`Could not find portal user with patient id ${patientId}`);
        }
        const portalUserId = portalUser.id;
        const baseUrl = _config.default.patientPortal.portalUrl;
        // Send form link and login code to a registered user
        if (type === _constants.PATIENT_COMMUNICATION_TYPES.PATIENT_PORTAL_REGISTERED_FORM) {
            const { token } = await portalOneTimeTokenService.createLoginToken(portalUserId);
            const loginLink = `${baseUrl}/login/${portalUserId}.${token}`;
            return (0, _replaceInTemplate.replaceInTemplate)(content, {
                loginLink,
                loginCode: token
            });
        }
        const { token } = await portalOneTimeTokenService.createRegisterToken(portalUserId);
        const registrationLink = `${baseUrl}/register/${portalUserId}.${token}`;
        return (0, _replaceInTemplate.replaceInTemplate)(content, {
            registrationLink
        });
    }
    constructor(context){
        super(context, 'portalCommunicationProcessor', _constants.PATIENT_COMMUNICATION_CHANNELS.PORTAL_EMAIL);
    }
};

//# sourceMappingURL=PortalCommunicationProcessor.js.map