"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "registerTelegramGetBotInfoEvent", {
    enumerable: true,
    get: function() {
        return registerTelegramGetBotInfoEvent;
    }
});
const _constants = require("@tamanu/constants");
const _logging = require("@tamanu/shared/services/logging");
const registerTelegramGetBotInfoEvent = (injector)=>{
    injector.websocketService.registerEvent(_constants.WS_EVENTS.TELEGRAM_GET_BOT_INFO, async ()=>{
        const result = await injector.telegramBotService.getBotInfo().catch((e)=>{
            _logging.log.error('Error getting bot info', e);
            return null;
        });
        injector.websocketService.emit(_constants.WS_EVENTS.TELEGRAM_BOT_INFO, result);
    });
};

//# sourceMappingURL=telegramGetBotInfo.js.map