"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    TIME_INTERVALS: function() {
        return TIME_INTERVALS;
    },
    randomDate: function() {
        return randomDate;
    },
    randomRecord: function() {
        return randomRecord;
    },
    randomRecordId: function() {
        return randomRecordId;
    },
    randomRecords: function() {
        return randomRecords;
    },
    splitIds: function() {
        return splitIds;
    }
});
const _chance = /*#__PURE__*/ _interop_require_default(require("chance"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const HOUR = 1000 * 60 * 60;
const DAY = HOUR * 24;
const TIME_INTERVALS = {
    HOUR,
    DAY
};
const chance = new _chance.default();
const randomDate = (minDaysAgo = 1, maxDaysAgo = 365)=>{
    const ago = chance.natural({
        min: DAY * minDaysAgo,
        max: DAY * maxDaysAgo
    });
    return new Date(Date.now() - ago);
};
const randomRecord = (models, modelName)=>models[modelName].findOne({
        order: models.ReferenceData.sequelize.random()
    });
const randomRecords = (models, modelName, count)=>models[modelName].findAll({
        order: models.ReferenceData.sequelize.random(),
        limit: count
    });
const randomRecordId = async (models, modelName)=>{
    const obj = await randomRecord(models, modelName);
    return (obj || {}).id || null;
};
const makeId = (s)=>s.trim().replace(/\s/g, '-').replace(/[^\w-]/g, '').toLowerCase();
const split = (s)=>s.split(/[\r\n]+/g).map((x)=>x.trim()).filter((x)=>x);
const splitIds = (ids)=>split(ids).map((s)=>({
            id: makeId(s),
            name: s
        }));

//# sourceMappingURL=utilities.js.map