"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const Sequelize = require('sequelize');
const _default = {
    up: async (query)=>{
        await query.createTable('attachments', {
            id: {
                type: Sequelize.STRING,
                defaultValue: Sequelize.UUIDV4,
                allowNull: false,
                primaryKey: true
            },
            type: {
                type: Sequelize.STRING(31),
                allowNull: false
            },
            size: {
                type: Sequelize.INTEGER,
                allowNull: true
            },
            data: {
                type: Sequelize.BLOB,
                allowNull: false
            },
            marked_for_push: {
                type: Sequelize.BOOLEAN,
                allowNull: false,
                defaultValue: true
            },
            pushed_at: {
                type: Sequelize.DATE,
                allowNull: true
            },
            pulled_at: {
                type: Sequelize.DATE,
                allowNull: true
            },
            created_at: {
                type: Sequelize.DATE,
                defaultValue: Sequelize.NOW
            },
            updated_at: {
                type: Sequelize.DATE,
                defaultValue: Sequelize.NOW
            },
            deleted_at: {
                type: Sequelize.DATE,
                defaultValue: Sequelize.NOW
            }
        });
    },
    down: async (query)=>{
        await query.dropTable('attachments');
    }
};

//# sourceMappingURL=016_addAttachmentTable.js.map