"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE_NAME = 'patient_death_data';
const ISO9075_DATE_FMT = 'YYYY-MM-DD';
async function up(query) {
    // 1. Create legacy columns
    await query.addColumn(TABLE_NAME, 'external_cause_date_legacy', {
        type: _sequelize.DataTypes.DATE
    });
    await query.addColumn(TABLE_NAME, 'last_surgery_date_legacy', {
        type: _sequelize.DataTypes.DATE
    });
    // 2. Copy data to legacy columns for backup
    await query.sequelize.query(`
    UPDATE ${TABLE_NAME}
    SET
      external_cause_date_legacy = external_cause_date,
      last_surgery_date_legacy = last_surgery_date;
  `);
    // 3.Change column types from of original columns from date to string & convert data to string
    await query.sequelize.query(`
    ALTER TABLE ${TABLE_NAME}
    ALTER COLUMN external_cause_date TYPE date_string
      USING TO_CHAR(external_cause_date, '${ISO9075_DATE_FMT}'),
    ALTER COLUMN last_surgery_date TYPE date_time_string
      USING TO_CHAR(last_surgery_date, '${ISO9075_DATE_FMT}');
`);
}
async function down(query) {
    await query.sequelize.query(`
    ALTER TABLE ${TABLE_NAME}
    ALTER COLUMN external_cause_date TYPE timestamp with time zone USING external_cause_date_legacy,
    ALTER COLUMN last_surgery_date TYPE timestamp with time zone USING last_surgery_date_legacy;
  `);
    await query.removeColumn(TABLE_NAME, 'external_cause_date_legacy');
    await query.removeColumn(TABLE_NAME, 'last_surgery_date_legacy');
}

//# sourceMappingURL=089_alterPatientDeathDataDateFields.js.map