"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.addColumn('patient_birth_data', 'attendant_at_birth', {
        type: _sequelize.default.STRING,
        allowNull: true
    });
    await query.addColumn('patient_birth_data', 'name_of_attendant_at_birth', {
        type: _sequelize.default.STRING,
        allowNull: true
    });
    await query.addColumn('patient_birth_data', 'birth_facility_id', {
        type: _sequelize.default.STRING,
        references: {
            model: 'facilities',
            key: 'id'
        },
        allowNull: true
    });
    await query.addColumn('patient_birth_data', 'registered_birth_place', {
        type: _sequelize.default.STRING,
        allowNull: true
    });
    await query.removeColumn('patient_birth_data', 'clinician_at_birth_id');
}
async function down(query) {
    await query.addColumn('patient_birth_data', 'clinician_at_birth_id', {
        type: _sequelize.default.STRING,
        references: {
            model: 'users',
            key: 'id'
        },
        allowNull: true
    });
    await query.removeColumn('patient_birth_data', 'attendant_at_birth');
    await query.removeColumn('patient_birth_data', 'name_of_attendant_at_birth');
    await query.removeColumn('patient_birth_data', 'registered_birth_place');
}

//# sourceMappingURL=089_updatePatientBirthDataColumns.js.map