"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.createTable('note_pages', {
        id: {
            type: _sequelize.default.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.default.UUIDV4
        },
        created_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.default.DATE,
            allowNull: true
        },
        note_type: {
            type: _sequelize.default.STRING,
            allowNull: false
        },
        record_id: {
            type: _sequelize.default.STRING,
            allowNull: false
        },
        record_type: {
            type: _sequelize.default.STRING,
            allowNull: false
        },
        date: {
            type: _sequelize.default.DATE,
            allowNull: false,
            defaultValue: _sequelize.default.NOW
        }
    });
}
async function down(query) {
    await query.dropTable('note_pages');
}

//# sourceMappingURL=090_addNotePagesTable.js.map