"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    return query.changeColumn('lab_request_logs', 'status', {
        type: _sequelize.DataTypes.STRING(31),
        allowNull: false
    });
}
const LAB_REQUEST_STATUSES = [
    'reception_pending',
    'results_pending',
    'to_be_verified',
    'verified',
    'published',
    'deleted',
    'cancelled'
];
async function down(query) {
    await query.sequelize.query('DROP TYPE "enum_lab_request_logs_status"');
    return query.changeColumn('lab_request_logs', 'status', {
        type: _sequelize.DataTypes.ENUM(LAB_REQUEST_STATUSES)
    });
}

//# sourceMappingURL=1675113624157-updateLabRequestLogStatus.js.map