/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    const tableExisted = await query.tableExists('invoice_line_items');
    if (tableExisted) await query.addColumn('invoice_line_items', 'discount_markup_reason', {
        type: _sequelize.DataTypes.STRING
    });
}
async function down(query) {
    const tableExisted = await query.tableExists('invoice_line_items');
    if (tableExisted) await query.removeColumn('invoice_line_items', 'discount_markup_reason');
}

//# sourceMappingURL=1715070274549-addAddDiscountMarkupReasonToInvoiceLineItemTable.js.map