/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn({
        schema: 'fhir',
        tableName: 'patients'
    }, 'is_live', {
        type: _sequelize.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true
    });
    await query.addColumn({
        schema: 'fhir',
        tableName: 'encounters'
    }, 'is_live', {
        type: _sequelize.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true
    });
    await query.addColumn({
        schema: 'fhir',
        tableName: 'immunizations'
    }, 'is_live', {
        type: _sequelize.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true
    });
    await query.addColumn({
        schema: 'fhir',
        tableName: 'organizations'
    }, 'is_live', {
        type: _sequelize.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true
    });
    await query.addColumn({
        schema: 'fhir',
        tableName: 'practitioners'
    }, 'is_live', {
        type: _sequelize.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true
    });
    await query.addColumn({
        schema: 'fhir',
        tableName: 'service_requests'
    }, 'is_live', {
        type: _sequelize.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true
    });
    await query.addColumn({
        schema: 'fhir',
        tableName: 'specimens'
    }, 'is_live', {
        type: _sequelize.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true
    });
    await query.addColumn({
        schema: 'fhir',
        tableName: 'non_fhir_medici_report'
    }, 'is_live', {
        type: _sequelize.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true
    });
}
async function down(query) {
    await query.removeColumn({
        schema: 'fhir',
        tableName: 'patients'
    }, 'is_live');
    await query.removeColumn({
        schema: 'fhir',
        tableName: 'encounters'
    }, 'is_live');
    await query.removeColumn({
        schema: 'fhir',
        tableName: 'immunizations'
    }, 'is_live');
    await query.removeColumn({
        schema: 'fhir',
        tableName: 'organizations'
    }, 'is_live');
    await query.removeColumn({
        schema: 'fhir',
        tableName: 'practitioners'
    }, 'is_live');
    await query.removeColumn({
        schema: 'fhir',
        tableName: 'service_requests'
    }, 'is_live');
    await query.removeColumn({
        schema: 'fhir',
        tableName: 'specimens'
    }, 'is_live');
    await query.removeColumn({
        schema: 'fhir',
        tableName: 'non_fhir_medici_report'
    }, 'is_live');
}

//# sourceMappingURL=1728511949669-AddIsLiveColumnToFhirResources.js.map