"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _selectFacilityIds = require("@tamanu/utils/selectFacilityIds");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    const isFacility = Boolean((0, _selectFacilityIds.selectFacilityIds)(_config.default));
    if (isFacility) {
        return;
    }
    const [hasUpdatedAtSyncTick] = await query.sequelize.query(`
    SELECT EXISTS (SELECT TRUE
    FROM information_schema.columns 
    WHERE table_schema = 'public' AND table_name = 'patients' AND column_name = 'updated_at_sync_tick');
  `);
    // If the patients table does not have the updated_at_sync_tick column it means this is
    // the first time deploying the server. If that's the case, we can skip the migration.
    if (!hasUpdatedAtSyncTick?.[0]?.exists) {
        return;
    }
    // Insert jobs to rematerialize patients that were deleted with "DESTROY" patient merge
    await query.sequelize.query(`
    WITH upstream AS (
      SELECT merged_into_id as id FROM patients WHERE deleted_at IS NOT NULL AND merged_into_id IS NOT NULL
    )
    INSERT INTO fhir.jobs (id, topic, payload)
    SELECT
      uuid_generate_v5(uuid_generate_v5(uuid_nil(), 'fhir.jobs_merged_patients'), upstream.id),
      'fhir.refresh.fromUpstream',
      json_build_object(
        'resource',
        'Patient',
        'upstreamId',
        upstream.id
      ) as payload
    FROM upstream
  `);
    await query.sequelize.query(`
    UPDATE patients
    SET
      deleted_at = updated_at,
      updated_at_sync_tick = (SELECT CAST(value AS bigint) FROM local_system_facts WHERE key = 'currentSyncTick')
    WHERE merged_into_id IS NOT NULL AND deleted_at IS NULL
  `);
}
async function down() {
// destructive up, no possible down
}

//# sourceMappingURL=1736984488579-markMergedPatientsAsDeleted.js.map