"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
async function up(query) {
    await query.createTable('portal_survey_assignments', {
        id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('current_timestamp', 6),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('current_timestamp', 6),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        patient_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            references: {
                model: 'patients',
                key: 'id'
            }
        },
        survey_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            references: {
                model: 'surveys',
                key: 'id'
            }
        },
        status: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            defaultValue: _constants.PORTAL_SURVEY_ASSIGNMENTS_STATUSES.OUTSTANDING
        },
        assigned_at: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        assigned_by_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        survey_response_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true,
            references: {
                model: 'survey_responses',
                key: 'id'
            }
        }
    });
    await query.addIndex('portal_survey_assignments', [
        'patient_id',
        'survey_id'
    ], {
        name: 'idx_patient_id_status'
    });
}
async function down(query) {
    await query.dropTable('portal_survey_assignments');
}

//# sourceMappingURL=1752638174400-addPortalSurveyAssignmentsTable.js.map