"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirServiceRequest", {
    enumerable: true,
    get: function() {
        return FhirServiceRequest;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Resource = require("./Resource");
const _ServiceRequest = require("../../utils/fhir/ServiceRequest");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let FhirServiceRequest = class FhirServiceRequest extends _Resource.FhirResource {
    static initModel(options, models) {
        super.initResource({
            identifier: _sequelize.DataTypes.JSONB,
            status: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            intent: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            category: _sequelize.DataTypes.JSONB,
            priority: _sequelize.DataTypes.TEXT,
            code: _sequelize.DataTypes.JSONB,
            orderDetail: _sequelize.DataTypes.JSONB,
            subject: {
                type: _sequelize.DataTypes.JSONB,
                allowNull: false
            },
            encounter: _sequelize.DataTypes.JSONB,
            occurrenceDateTime: _sequelize.DataTypes.TEXT,
            requester: _sequelize.DataTypes.JSONB,
            locationCode: _sequelize.DataTypes.JSONB,
            note: _sequelize.DataTypes.JSONB,
            specimen: _sequelize.DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.ImagingRequest,
            models.LabRequest
        ];
        this.upstreams = [
            models.ImagingRequest,
            models.ImagingRequestArea,
            models.ImagingAreaExternalCode,
            models.Encounter,
            models.Facility,
            models.Location,
            models.LocationGroup,
            models.Patient,
            models.ReferenceData,
            models.User,
            models.LabRequest,
            models.LabTest,
            models.LabTestType,
            models.LabTestPanelRequest,
            models.LabTestPanel,
            models.Note
        ];
        this.referencedResources = [
            models.FhirPatient,
            models.FhirEncounter,
            models.FhirPractitioner,
            models.FhirSpecimen
        ];
    }
    async updateMaterialisation() {
        const upstream = await this.getUpstream((0, _ServiceRequest.getQueryOptions)(this.sequelize.models));
        const values = await (0, _ServiceRequest.getValues)(upstream, this.sequelize.models);
        this.set(values);
    }
    async updateIsLive() {
        const upstream = await this.getUpstream((0, _ServiceRequest.getQueryOptions)(this.sequelize.models));
        const isLive = (0, _ServiceRequest.getIsLive)(upstream, this.sequelize.models);
        this.isLive = isLive;
    }
    async shouldForceRematerialise() {
        const upstream = await this.getUpstream((0, _ServiceRequest.getQueryOptions)(this.sequelize.models));
        return (0, _ServiceRequest.shouldForceRematerialise)(upstream, this, this.sequelize.models);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id) {
        const { ImagingRequest, LabRequest } = this.sequelize.models;
        if (upstreamTable === ImagingRequest.tableName) {
            return (0, _ServiceRequest.fromImagingRequests)(this.sequelize.models, table, id);
        }
        if (upstreamTable === LabRequest.tableName) {
            return (0, _ServiceRequest.fromLabRequests)(this.sequelize.models, table, id);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ..._ServiceRequest.searchParameters
        };
    }
};
_define_property(FhirServiceRequest, "CAN_DO", new Set([
    _constants.FHIR_INTERACTIONS.INSTANCE.READ,
    _constants.FHIR_INTERACTIONS.TYPE.SEARCH,
    _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
]));

//# sourceMappingURL=FhirServiceRequest.js.map