"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FHIR_ENDPOINT_SCHEMA", {
    enumerable: true,
    get: function() {
        return FHIR_ENDPOINT_SCHEMA;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const endpointStatuses = [
    'active',
    'suspended',
    'error',
    'off',
    'entered-in-error',
    'test'
];
const FHIR_ENDPOINT_SCHEMA = _yup.object({
    resourceType: _yup.string().oneOf([
        'Endpoint'
    ], 'ImagingStudy only supports a contained Endpoint resource').required(),
    status: _yup.string().oneOf(endpointStatuses).required(),
    address: _yup.string().required(),
    connectionType: _yup.object({
        code: _yup.string().required(),
        display: _yup.string().required()
    }).required(),
    payloadType: _yup.array().of(_yup.object({
        code: _yup.string().oneOf([
            'none'
        ], 'ImagingStudy contained Endpoint only supports a payload type of None').required(),
        display: _yup.string().oneOf([
            'None'
        ], 'ImagingStudy contained Endpoint only supports a payload type of None').required()
    })).required()
});

//# sourceMappingURL=fhirEndpoint.js.map