import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
import { buildEncounterLinkedSyncFilter } from '../sync/buildEncounterLinkedSyncFilter';
import { buildEncounterLinkedLookupJoins, buildEncounterLinkedLookupSelect } from '../sync/buildEncounterLinkedLookupFilter';
export class InvoiceInsurer extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            percentage: {
                type: DataTypes.DECIMAL,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Invoice, {
            foreignKey: 'invoiceId',
            as: 'invoice'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'insurerId',
            as: 'insurer'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return buildEncounterLinkedSyncFilter([
            this.tableName,
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await buildEncounterLinkedLookupSelect(this),
            joins: buildEncounterLinkedLookupJoins(this, [
                'invoices',
                'encounters'
            ])
        };
    }
}

//# sourceMappingURL=InvoiceInsurer.js.map