import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
export declare class InvoicePayment extends Model {
    id: string;
    date: string;
    receiptNumber: string;
    amount: number;
    invoiceId?: string;
    updatedByUserId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
    static getListReferenceAssociations(models: Models): ({
        model: typeof import("./User").User;
        as: string;
        include?: undefined;
    } | {
        model: typeof import("./InvoicePatientPayment").InvoicePatientPayment;
        as: string;
        include: {
            model: typeof import("./ReferenceData").ReferenceData;
            as: string;
        }[];
    } | {
        model: typeof import("./InvoiceInsurerPayment").InvoiceInsurerPayment;
        as: string;
        include: {
            model: typeof import("./ReferenceData").ReferenceData;
            as: string;
        }[];
    })[];
}
//# sourceMappingURL=InvoicePayment.d.ts.map