import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
export declare class PharmacyOrderPrescription extends Model {
    id: string;
    pharmacyOrderId: string;
    prescriptionId: string;
    quantity?: number;
    repeats?: number;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static getListReferenceAssociations(): string[];
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
}
//# sourceMappingURL=PharmacyOrderPrescription.d.ts.map