function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import { DataTypes } from 'sequelize';
import { FHIR_INTERACTIONS } from '@tamanu/constants';
import { FhirResource } from './Resource';
import { getQueryOptions, getValues, fromUsers, searchParameters } from '../../utils/fhir/Practitioner';
export class FhirPractitioner extends FhirResource {
    static initModel(options, models) {
        super.initResource({
            name: DataTypes.JSONB,
            identifier: DataTypes.JSONB,
            telecom: DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.User
        ];
        this.upstreams = [
            models.User
        ];
    }
    async updateMaterialisation() {
        const upstream = await this.getUpstream(getQueryOptions());
        const values = await getValues(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id) {
        const { User } = this.sequelize.models;
        if (upstreamTable === User.tableName) {
            return fromUsers(this.sequelize.models, table, id);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ...searchParameters
        };
    }
}
_define_property(FhirPractitioner, "CAN_DO", new Set([
    FHIR_INTERACTIONS.INSTANCE.READ,
    FHIR_INTERACTIONS.TYPE.SEARCH,
    FHIR_INTERACTIONS.INTERNAL.MATERIALISE
]));

//# sourceMappingURL=FhirPractitioner.js.map