"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirCoding", {
    enumerable: true,
    get: function() {
        return FhirCoding;
    }
});
const _lodash = require("lodash");
const _crypto = /*#__PURE__*/ _interop_require_default(require("crypto"));
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _baseType = require("./baseType");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
let FhirCoding = class FhirCoding extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            system: _yup.string().url().nullable().default(null),
            version: _yup.string().nullable().default(null),
            code: _yup.string().nullable().default(null),
            display: _yup.string().nullable().default(null),
            userSelected: _yup.boolean().transform(function quantityParse(value, originalValue) {
                if (this.isType(value)) return value;
                if (originalValue.startsWith('t')) return true;
                if (originalValue.startsWith('f')) return false;
                return null;
            }).nullable().default(null)
        }).noUnknown();
    }
    static fake(model, { fieldName }, id) {
        return new this({
            system: `https://tamanu.io/${model.name}/${_crypto.default.randomUUID()}`,
            version: `${(0, _lodash.random)(1, 9)}.0`,
            code: `${fieldName}.${id}`,
            display: fieldName.toUpperCase(),
            userSelected: (0, _lodash.sample)([
                null,
                true,
                false
            ])
        });
    }
};

//# sourceMappingURL=coding.js.map