"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Page", {
    enumerable: true,
    get: function() {
        return Page;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _languageContext = require("./languageContext");
const _flattenStyles = require("./flattenStyles");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const Page = ({ style, ...props })=>{
    const { makeIntlStyleSheet, pdfFont } = (0, _languageContext.useLanguageContext)();
    const mergedStyle = (0, _flattenStyles.flatten)(style);
    const newStyles = makeIntlStyleSheet({
        fontFamily: pdfFont,
        ...mergedStyle
    });
    return /*#__PURE__*/ _react.default.createElement(_renderer.Page, {
        style: newStyles,
        ...props
    });
};

//# sourceMappingURL=Page.js.map