'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const toMerged = require('../_chunk/toMerged-DGFrN7.js');

function mergeWith(target, source, merge) {
    const sourceKeys = Object.keys(source);
    for (let i = 0; i < sourceKeys.length; i++) {
        const key = sourceKeys[i];
        const sourceValue = source[key];
        const targetValue = target[key];
        const merged = merge(targetValue, sourceValue, key, target, source);
        if (merged != null) {
            target[key] = merged;
        }
        else if (Array.isArray(sourceValue)) {
            target[key] = mergeWith(targetValue ?? [], sourceValue, merge);
        }
        else if (toMerged.isObjectLike(targetValue) && toMerged.isObjectLike(sourceValue)) {
            target[key] = mergeWith(targetValue ?? {}, sourceValue, merge);
        }
        else if (targetValue === undefined || sourceValue !== undefined) {
            target[key] = sourceValue;
        }
    }
    return target;
}

function omit(obj, keys) {
    const result = { ...obj };
    for (let i = 0; i < keys.length; i++) {
        const key = keys[i];
        delete result[key];
    }
    return result;
}

function pick(obj, keys) {
    const result = {};
    for (let i = 0; i < keys.length; i++) {
        const key = keys[i];
        if (Object.hasOwn(obj, key)) {
            result[key] = obj[key];
        }
    }
    return result;
}

exports.clone = toMerged.clone;
exports.cloneDeep = toMerged.cloneDeep;
exports.cloneDeepWith = toMerged.cloneDeepWith;
exports.findKey = toMerged.findKey;
exports.flattenObject = toMerged.flattenObject;
exports.invert = toMerged.invert;
exports.mapKeys = toMerged.mapKeys;
exports.mapValues = toMerged.mapValues;
exports.merge = toMerged.merge;
exports.omitBy = toMerged.omitBy;
exports.pickBy = toMerged.pickBy;
exports.toMerged = toMerged.toMerged;
exports.mergeWith = mergeWith;
exports.omit = omit;
exports.pick = pick;
