"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ENCOUNTER_TYPES: function() {
        return ENCOUNTER_TYPES;
    },
    ENCOUNTER_TYPE_ABBREVIATION_LABELS: function() {
        return ENCOUNTER_TYPE_ABBREVIATION_LABELS;
    },
    ENCOUNTER_TYPE_LABELS: function() {
        return ENCOUNTER_TYPE_LABELS;
    },
    ENCOUNTER_TYPE_VALUES: function() {
        return ENCOUNTER_TYPE_VALUES;
    }
});
const ENCOUNTER_TYPES = {
    ADMISSION: 'admission',
    CLINIC: 'clinic',
    IMAGING: 'imaging',
    EMERGENCY: 'emergency',
    OBSERVATION: 'observation',
    TRIAGE: 'triage',
    SURVEY_RESPONSE: 'surveyResponse',
    VACCINATION: 'vaccination'
};
const ENCOUNTER_TYPE_LABELS = {
    [ENCOUNTER_TYPES.ADMISSION]: 'Hospital admission',
    [ENCOUNTER_TYPES.TRIAGE]: 'Triage',
    [ENCOUNTER_TYPES.CLINIC]: 'Clinic',
    [ENCOUNTER_TYPES.IMAGING]: 'Imaging',
    [ENCOUNTER_TYPES.EMERGENCY]: 'Emergency short stay',
    [ENCOUNTER_TYPES.OBSERVATION]: 'Active ED patient',
    [ENCOUNTER_TYPES.SURVEY_RESPONSE]: 'Form response',
    [ENCOUNTER_TYPES.VACCINATION]: 'Vaccination record'
};
const ENCOUNTER_TYPE_VALUES = Object.values(ENCOUNTER_TYPES);
const ENCOUNTER_TYPE_ABBREVIATION_LABELS = {
    [ENCOUNTER_TYPES.ADMISSION]: 'HA',
    [ENCOUNTER_TYPES.TRIAGE]: 'T',
    [ENCOUNTER_TYPES.CLINIC]: 'C',
    [ENCOUNTER_TYPES.IMAGING]: 'I',
    [ENCOUNTER_TYPES.EMERGENCY]: 'ESS',
    [ENCOUNTER_TYPES.OBSERVATION]: 'AEP',
    [ENCOUNTER_TYPES.SURVEY_RESPONSE]: 'FR',
    [ENCOUNTER_TYPES.VACCINATION]: 'VR'
};

//# sourceMappingURL=encounters.js.map