/**
 * @param {import('sequelize').QueryInterface} query
 */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.removeConstraint('reference_data_relations', 'reference_data_relations_reference_data_id_type_key');
    await query.addConstraint('reference_data_relations', {
        fields: [
            'reference_data_id',
            'reference_data_parent_id',
            'type'
        ],
        type: 'unique',
        name: 'reference_data_relations_unique_index'
    });
}
async function down(query) {
    await query.removeConstraint('reference_data_relations', 'reference_data_relations_unique_index');
    await query.addConstraint('reference_data_relations', {
        fields: [
            'reference_data_id',
            'type'
        ],
        type: 'unique',
        name: 'reference_data_relations_reference_data_id_type_key'
    });
}

//# sourceMappingURL=1724653055313-updateReferenceDataRelationUniqueIndex.js.map