"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    // Create pharmacy_orders table
    await query.createTable('pharmacy_orders', {
        id: {
            type: _sequelize.DataTypes.UUID,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
        },
        ordering_clinician_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        encounter_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            references: {
                model: 'encounters',
                key: 'id'
            }
        },
        comments: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    // Create pharmacy_order_prescriptions table
    await query.createTable('pharmacy_order_prescriptions', {
        id: {
            type: _sequelize.DataTypes.UUID,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
        },
        pharmacy_order_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'pharmacy_orders',
                key: 'id'
            }
        },
        prescription_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            references: {
                model: 'prescriptions',
                key: 'id'
            }
        },
        quantity: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: false
        },
        repeats: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
}
async function down(query) {
    await query.dropTable('pharmacy_order_prescriptions');
    await query.dropTable('pharmacy_orders');
}

//# sourceMappingURL=1748555633926-createPharmacyOrdersTables.js.map