import { Model } from './Model';
import type { InitOptions } from '../types/model';
import type { ModelSanitizeArgs } from '../types/sync';
export declare class Asset extends Model {
    id: string;
    name?: string;
    type?: string;
    data?: Buffer;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    /**
     * This is only used when inserting asset manually through RestClient
     * Asset is PULL_FROM_CENTRAL, i.e. we don't sync asset up from devices to sync servers.
     */
    static sanitizeForCentralServer({ data, ...restOfValues }: ModelSanitizeArgs): {
        data: Buffer<any>;
    };
    static sanitizeForFacilityServer({ data, ...restOfValues }: {
        data: any;
        [key: string]: any;
    }): {
        data: Buffer<any>;
    };
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): Promise<null>;
}
//# sourceMappingURL=Asset.d.ts.map