"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirPractitioner", {
    enumerable: true,
    get: function() {
        return FhirPractitioner;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Resource = require("./Resource");
const _Practitioner = require("../../utils/fhir/Practitioner");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let FhirPractitioner = class FhirPractitioner extends _Resource.FhirResource {
    static initModel(options, models) {
        super.initResource({
            name: _sequelize.DataTypes.JSONB,
            identifier: _sequelize.DataTypes.JSONB,
            telecom: _sequelize.DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.User
        ];
        this.upstreams = [
            models.User
        ];
    }
    async updateMaterialisation() {
        const upstream = await this.getUpstream((0, _Practitioner.getQueryOptions)());
        const values = await (0, _Practitioner.getValues)(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id) {
        const { User } = this.sequelize.models;
        if (upstreamTable === User.tableName) {
            return (0, _Practitioner.fromUsers)(this.sequelize.models, table, id);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ..._Practitioner.searchParameters
        };
    }
};
_define_property(FhirPractitioner, "CAN_DO", new Set([
    _constants.FHIR_INTERACTIONS.INSTANCE.READ,
    _constants.FHIR_INTERACTIONS.TYPE.SEARCH,
    _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
]));

//# sourceMappingURL=FhirPractitioner.js.map