"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "filterFromEncounters", {
    enumerable: true,
    get: function() {
        return filterFromEncounters;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
function filterFromEncounters(models, table) {
    const { Encounter } = models;
    switch(table){
        case Encounter.tableName:
            return {
                where: {
                    encounterType: {
                        [_sequelize.Op.ne]: _constants.ENCOUNTER_TYPES.SURVEY_RESPONSE
                    }
                }
            };
        default:
            return null;
    }
}

//# sourceMappingURL=getQueryToFilterUpstream.js.map