"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "searchParameters", {
    enumerable: true,
    get: function() {
        return searchParameters;
    }
});
const _constants = require("@tamanu/constants");
const searchParameters = {
    identifier: {
        type: _constants.FHIR_SEARCH_PARAMETERS.TOKEN,
        path: [
            [
                'identifier',
                '[]'
            ]
        ],
        tokenType: _constants.FHIR_SEARCH_TOKEN_TYPES.VALUE
    },
    category: {
        type: _constants.FHIR_SEARCH_PARAMETERS.TOKEN,
        path: [
            [
                'category',
                '[]',
                'coding',
                '[]'
            ]
        ],
        tokenType: _constants.FHIR_SEARCH_TOKEN_TYPES.CODING
    },
    intent: {
        type: _constants.FHIR_SEARCH_PARAMETERS.STRING,
        path: [
            [
                'intent'
            ]
        ]
    },
    occurrence: {
        type: _constants.FHIR_SEARCH_PARAMETERS.DATE,
        path: [
            [
                'occurrenceDateTime'
            ]
        ]
    },
    priority: {
        type: _constants.FHIR_SEARCH_PARAMETERS.STRING,
        path: [
            [
                'priority'
            ]
        ]
    },
    status: {
        type: _constants.FHIR_SEARCH_PARAMETERS.STRING,
        path: [
            [
                'status'
            ]
        ]
    },
    subject: {
        type: _constants.FHIR_SEARCH_PARAMETERS.REFERENCE,
        path: [
            [
                'subject'
            ]
        ],
        referenceTypes: [
            'Patient'
        ]
    },
    encounter: {
        type: _constants.FHIR_SEARCH_PARAMETERS.REFERENCE,
        path: [
            [
                'encounter'
            ]
        ],
        referenceTypes: [
            'Encounter'
        ]
    },
    requester: {
        type: _constants.FHIR_SEARCH_PARAMETERS.REFERENCE,
        path: [
            [
                'requester'
            ]
        ],
        referenceTypes: [
            'Practitioner'
        ]
    },
    specimen: {
        type: _constants.FHIR_SEARCH_PARAMETERS.REFERENCE,
        path: [
            [
                'specimen',
                '[]'
            ]
        ],
        referenceTypes: [
            'Specimen'
        ]
    }
};

//# sourceMappingURL=searchParameters.js.map