import { Model as BaseModel, type ModelAttributes, Sequelize } from 'sequelize';
import type { InitOptions, Models } from '../types/model';
import type { SyncHookSnapshotChanges, ModelSanitizeArgs, SessionConfig, SyncSnapshotAttributes } from '../types/sync';
export declare class Model<TModelAttributes extends Record<string, any> = any, _TCreationAttributes extends {} = TModelAttributes> extends BaseModel<TModelAttributes, _TCreationAttributes> {
    id: any;
    createdAt: Date;
    updatedAt?: Date;
    deletedAt?: Date;
    sequelize: {
        models: Models;
    } & Omit<Sequelize, 'models'>;
    static sequelize: {
        models: Models;
    } & Omit<Sequelize, 'models'>;
    static syncDirection: InitOptions['syncDirection'];
    static defaultIdValue?: string | number;
    static usesPublicSchema: boolean;
    static buildSyncFilter: () => string | null;
    static buildPatientSyncFilter: (_patientCount: number, _markedForSyncPatientsTable: string, _sessionConfig: SessionConfig) => string | null;
    static adjustDataPostSyncPush?: (ids: string[]) => Promise<void>;
    static incomingSyncHook?: (changes: SyncSnapshotAttributes[]) => Promise<SyncHookSnapshotChanges | undefined>;
    static init(modelAttributes: ModelAttributes, { syncDirection, timestamps, schema, ...options }: Omit<InitOptions, 'primaryKey'>): any;
    static generateId(): unknown;
    /**
     * Generates a uuid via the database
     */
    static generateDbUuid(): Promise<any>;
    static validateSync(timestamps: boolean): void;
    forResponse(): any;
    toJSON(): any;
    getModelName(): string;
    static getListReferenceAssociations(_models?: Models): any | undefined;
    static getFullReferenceAssociations(): any;
    static findByIds(ids: unknown[], paranoid?: boolean): Promise<Model<any, any>[]>;
    static sanitizeForCentralServer(values: ModelSanitizeArgs): {
        [key: string]: any;
    };
    static sanitizeForFacilityServer(values: object): object;
}
//# sourceMappingURL=Model.d.ts.map