import { Model } from './Model';
import { buildPatientSyncFilterViaPatientId } from '../sync/buildPatientSyncFilterViaPatientId';
import type { InitOptions, ModelProperties, Models } from '../types/model';
export declare class PatientAdditionalData extends Model {
    id: string;
    patientId: string;
    placeOfBirth?: string;
    bloodType?: string;
    primaryContactNumber?: string;
    secondaryContactNumber?: string;
    maritalStatus?: string;
    cityTown?: string;
    streetVillage?: string;
    educationalLevel?: string;
    socialMedia?: string;
    title?: string;
    birthCertificate?: string;
    drivingLicense?: string;
    passport?: string;
    passportNumber?: string;
    emergencyContactName?: string;
    emergencyContactNumber?: string;
    motherId?: string;
    fatherId?: string;
    healthCenterId?: string;
    secondaryVillageId?: string;
    updatedAtByField?: Record<string, any>;
    insurerPolicyNumber?: string;
    registeredById?: string;
    nationalityId?: string;
    countryId?: string;
    divisionId?: string;
    subdivisionId?: string;
    medicalAreaId?: string;
    nursingZoneId?: string;
    settlementId?: string;
    ethnicityId?: string;
    occupationId?: string;
    religionId?: string;
    patientBillingTypeId?: string;
    countryOfBirthId?: string;
    insurerId?: string;
    static initModel(options: InitOptions): void;
    static initRelations(models: Models): void;
    static getFullReferenceAssociations(): string[];
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
    }>;
    static buildPatientSyncFilter: typeof buildPatientSyncFilterViaPatientId;
    static getForPatient(patientId: string): Promise<PatientAdditionalData | null>;
    static getOrCreateForPatient(patientId: string): Promise<PatientAdditionalData>;
    static updateForPatient(patientId: string, values: ModelProperties<PatientAdditionalData>): Promise<PatientAdditionalData>;
}
//# sourceMappingURL=PatientAdditionalData.d.ts.map