import { DataTypes, type InitOptions as BaseInitOptions, type Model as BaseModel } from 'sequelize';
import * as models from '../models';
import type { Model } from '../models/Model';
import type { SyncDirectionValues } from './sync';
type PrimaryKey = {
    type: typeof DataTypes.STRING;
    defaultValue: unknown extends string ? string : never;
    allowNull: boolean;
    primaryKey: boolean;
};
export interface InitOptions extends BaseInitOptions {
    syncDirection: SyncDirectionValues;
    primaryKey: PrimaryKey;
    hackToSkipEncounterValidation?: boolean;
}
export type Models = typeof models;
type NonFunctionKeys<T> = {
    [P in keyof T]: T[P] extends Function ? never : P;
}[keyof T];
export type ModelProperties<T> = Omit<Pick<T, NonFunctionKeys<T>>, keyof BaseModel>;
export declare function dateTimeType(fieldName: string, config?: {}): {
    type: DataTypes.AbstractDataTypeConstructor;
    set(this: Model, value?: null | string | Date): void;
};
export declare function dateType(fieldName: string, config?: {}): {
    type: DataTypes.AbstractDataTypeConstructor;
    set(this: Model, value?: null | string | Date): void;
};
export {};
//# sourceMappingURL=model.d.ts.map