"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "labRequestLog", {
    enumerable: true,
    get: function() {
        return labRequestLog;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const labRequestLog = _express.default.Router();
labRequestLog.get('/labRequest/:id', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, params } = req;
    req.checkPermission('list', 'LabRequestLog');
    const logs = await models.LabRequestLog.findAll({
        where: {
            labRequestId: params.id
        },
        order: [
            [
                'createdAt',
                'DESC'
            ]
        ]
    });
    const logsWithDisplayName = await Promise.all(logs.map(async (log)=>{
        const updatedByDisplayName = (await models.User.findByPk(log.updatedById)).dataValues.displayName;
        return {
            ...log.dataValues,
            updatedByDisplayName
        };
    }));
    res.send({
        count: logsWithDisplayName.length,
        data: logsWithDisplayName
    });
}));

//# sourceMappingURL=labRequestLog.js.map